<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Currency extends Model 
{

    protected $table = 'currencies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function listings()
    {
        return $this->hasMany('App\Models\Listing\Listing', 'currency_id');
    }

    public function lines()
    {
        return $this->hasMany('App\Models\Finance\Line', 'currency_id');
    }

    public function invoices()
    {
        return $this->hasMany('App\Models\Finance\Invoice', 'invoice_id');
    }

    public function settlements()
    {
        return $this->hasMany('App\Models\Finance\Settlement', 'currency_id');
    }

}